//=============================================================================
// Parent Class.
//=============================================================================
class CraftingPin extends CraftingPart abstract;

var float ReloadMod, RateMod;
var sound AfterFireSound;
var bool bHasAuto, bHasBurst;

function string GetStats()
{
 local string S;
 
 //S = CurDurability$"/"$Durability;
 
 if (RateMod != 0) S = S@"Refire ";
 if (RateMod > 0) S = S$"+";
 if (RateMod < 0) S = S$"-";
 if (RateMod != 0) S = S$FormatFloatString(ABS(RateMod), 0.05);
 
 if (ReloadMod > 0 || ReloadMod < 0) S = S@"Rld ";
 if (ReloadMod > 0) S = S$"+";
 if (ReloadMod < 0) S = S$"-";
 if (ReloadMod > 0 || ReloadMod < 0) S = S$FormatFloatString(ABS(ReloadMod), 0.1);
 
 if (bHasAuto || bHasBurst)
 {
  S = S@"Mds: ";
  if (bHasAuto) S = S$"Auto ";
  if (bHasBurst) S = S$"Brst ";
 }
 
 return S;
}

defaultproperties
{
}
